package com.google.android.gcm.ccs.server;

import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class LoggingConnectionListener implements ConnectionListener {
	
	
	private XMPPGCMConnection connection;

	public LoggingConnectionListener(XMPPGCMConnection connection) {
		this.connection = connection;
	}
	
	 @Override
     public void connected(XMPPConnection xmppConnection) {
		 log.info("Connected.");
     }


     @Override
     public void reconnectionSuccessful() {
    	 if(connection.isDrainning()){
    		 connection.setDrainning(false);
    	 }
    	 log.info("{} Reconnect SuccesFul", connection.isDrainning() ? "Drainning Connection" : "Conenction");
     }

     @Override
     public void reconnectionFailed(Exception e) {
    	 log.info("Reconnection failed.. ", e);
     }

     @Override
     public void reconnectingIn(int seconds) {
    	 log.info("Reconnecting in {} secs", seconds);
     }

     @Override
     public void connectionClosedOnError(Exception e) {
         log.info("Connection closed on error.");
     }

     @Override
     public void connectionClosed() {
    	 log.info("Connection {} closed.", connection.isDrainning() ? "Drainning" : "");
     }

	@Override
	public void authenticated(XMPPConnection arg0, boolean arg1) {
		log.info("Connection authenticated.");
	}
}