package com.google.android.gcm.ccs.server;

import org.jivesoftware.smack.packet.DefaultExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;

import com.humuson.tms.batch.job.constrants.GCMConstants;

public class GcmPacketExtension extends DefaultExtensionElement {
    
	private final String json;

    public GcmPacketExtension(String json) {
        super(GCMConstants.GCM_ELEMENT_NAME, GCMConstants.GCM_NAMESPACE);
        this.json = json;
    }

    public String getJson() {
        return json;
    }

    @Override
    public String toXML() {
        return String.format("<%s xmlns=\"%s\">%s</%s>",
        		GCMConstants.GCM_ELEMENT_NAME, GCMConstants.GCM_NAMESPACE,
              StringUtils.escapeForXML(json), GCMConstants.GCM_ELEMENT_NAME);
    }

    public Stanza toPacket() {
        Message message = new Message();
        message.addExtension(this);
        return message;
    }
}
