package com.google.android.gcm.ccs.server;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import javax.net.ssl.SSLSocketFactory;

import org.jivesoftware.smack.ConnectionConfiguration.SecurityMode;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.DefaultExtensionElement;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.xmlpull.v1.XmlPullParser;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.job.constrants.GCMConstants;
import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushResultService;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class CcsConnectionManager {

    @Autowired
    JdbcTemplate jdbcTemplate;
    
	@Autowired
	PushResultService pushResultSeviceImpl;
    
	@Value("#{config['xmpp.connection.size']}")
	private int maxConnection;
	
    @Value("#{config['send.gcm.type']}")
	protected String gcmType;
    
    @Value("#{config['xmpp.upstream.use.flag']}")
	private boolean upstreamUseFlag;
	
    private String selectAdroidAppInfo;
    
    private ConcurrentHashMap<String, List <XMPPGCMConnection>> connectionStorage = new ConcurrentHashMap<String, List <XMPPGCMConnection>>();
    private ConcurrentHashMap<String, Integer > storageIdxMap = new ConcurrentHashMap<String, Integer>();
    
    @Autowired
	private PushInfoService<App, PushMessage> pushInfoServiceImpl;
	
	@Autowired
	@Qualifier(value = "mqCampResProducer")
	private MqProducer mqCampResProducer;
	
	@Autowired
	@Qualifier(value = "mqAutoResProducer")
	private MqProducer mqAutoResProducer;
	
    
    public CcsConnectionManager(){    	
    	    	
//    	ProviderManager.getInstance().addExtensionProvider(GCMConstants.GCM_ELEMENT_NAME, GCMConstants.GCM_NAMESPACE,
//                new PacketExtensionProvider() {
//                    @Override
//                    public PacketExtension parseExtension(XmlPullParser parser) throws
//                            Exception {
//                        String json = parser.nextText();
//                        return new GcmPacketExtension(json);
//                    }
//                });
    
    	ReconnectionManager.setEnabledPerDefault(true);
    	
    	ProviderManager.addExtensionProvider(GCMConstants.GCM_ELEMENT_NAME, GCMConstants.GCM_NAMESPACE, new  ExtensionElementProvider<ExtensionElement>() {
            @Override
            public DefaultExtensionElement parse(XmlPullParser parser,int initialDepth) throws org.xmlpull.v1.XmlPullParserException,
            IOException {
                String json = parser.nextText();
                return new GcmPacketExtension(json);
            }
        });
    }
    
    public void init(){
    	if (gcmType.equalsIgnoreCase("xmpp")){
    		long senderId ;
    		String apiKey ;
    		
    		List <App> appInfoList = jdbcTemplate.query(selectAdroidAppInfo, new RowMapper<App>() {
				
				@Override
				public App mapRow(ResultSet rs, int rowNum) throws SQLException {
					// TODO Auto-generated method stub
					App app = new App();
					app.setGcmProjectNum(rs.getLong(App.GCM_PROJECT_NUM));
					app.setGcmApiKey(rs.getString(App.GCM_API_KEY1));
					return app;
				}
			});
    		
    		for (App appInfo : appInfoList) {
    			senderId = appInfo.getGcmProjectNum();
    			apiKey = appInfo.getGcmApiKey();
    			
    			if (apiKey.length() > 20) {
    				if (getConnection(senderId, apiKey) == null){
    					log.error("init connect() fail!  senderId : {}, apiKey : {}", senderId, apiKey);    				
    				}else {
    					log.info("init connect() senderId : {}, apiKey : {}", senderId, apiKey);    				
    				}
    			} else {
    				log.error("init not try connecting!  senderId : {}, apiKey : {}", senderId, apiKey); 
    			}
    			
			}
    	}
    }
    
    public synchronized XMPPGCMConnection getConnection(long senderId, String apiKey){    	
    	int indicator = 0;
    	
    	if(storageIdxMap.containsKey(apiKey)){
    		indicator = storageIdxMap.get(apiKey);
    		storageIdxMap.put(apiKey, (indicator + 1) % maxConnection);
    		
    		log.debug("getConnection indicator:{} senderId:{} apiKey:{} ", indicator, senderId ,apiKey);
    	}
    	
    	if(connectionStorage.containsKey(apiKey)){
    		if(connectionStorage.get(apiKey).get(indicator).isConnected() == true 
    				&& !connectionStorage.get(apiKey).get(indicator).isDrainning()){
    			return connectionStorage.get(apiKey).get(indicator);
    		} else{
//    			if(connectionStorage.get(apiKey).get(indicator).isConnected() ){
//    				getConnection(senderId,apiKey);
//    			}
    			try {
					connect(senderId, apiKey);
					log.debug("Reconnect and getConncetion()! indicator: {} senderId: {} apiKey: {}", indicator, senderId, apiKey);
					return connectionStorage.get(apiKey).get(indicator);
				} catch (Exception e) {
	    			// TODO: handle exception
	    			log.error("Retry getConncetion() error! indicator: {} senderId: {} apiKey: {}, Error : {}", indicator, senderId, apiKey, e);
	    			return null;
	    		}
    		}
    	}else{
    		try {
        		connect(senderId, apiKey);        				
        		return connectionStorage.get(apiKey).get(indicator);
    		} catch (Exception e) {
    			// TODO: handle exception
    			log.error("getConncetion() error! indicator: {} senderId: {} apiKey: {}, Error : {}", indicator, senderId, apiKey, e);
    			return null;
    		}
    	}
    }
    
    public synchronized void connect(long senderId, String apiKey)
    		throws XMPPException, IOException, SmackException {
    	List <XMPPGCMConnection> connList = new ArrayList<XMPPGCMConnection>();
    	for (int i = 0; i < maxConnection; i++) {
			
//    		ConnectionConfiguration config =
//    				new ConnectionConfiguration(GCMConstants.GCM_SERVER, GCMConstants.GCM_PORT);
//    		config.setSecurityMode(SecurityMode.enabled);
//    		config.setReconnectionAllowed(true);
//    		config.setRosterLoadedAtLogin(false);
//    		config.setSendPresence(false);
//    		config.setSocketFactory(SSLSocketFactory.getDefault());
    		
    		XMPPTCPConnectionConfiguration config =
        			XMPPTCPConnectionConfiguration.builder()
        			.setServiceName(GCMConstants.GCM_SERVER)
        		     .setHost(GCMConstants.GCM_SERVER)
        		     .setCompressionEnabled(false)
        		     .setPort(GCMConstants.GCM_PORT)
        		     .setConnectTimeout(30000)
        		     .setSecurityMode(SecurityMode.disabled)
        		     .setSendPresence(false)
        		     .setSocketFactory(SSLSocketFactory.getDefault())
        		    .build();
//        		     .setDebuggerEnabled(true)
    		final XMPPGCMConnection connection = new XMPPGCMConnection(config);
    		connection.setApiKey(apiKey);
    		connection.setProjectNumber(senderId);
    		ReconnectionManager.getInstanceFor(connection).enableAutomaticReconnection();
    		connection.connect();
    		
    		connection.addConnectionListener(new LoggingConnectionListener(connection));
    		
    		connection.addSyncStanzaListener(
    				new CcsStanzaListener(connection,mqCampResProducer,mqAutoResProducer,pushInfoServiceImpl, pushResultSeviceImpl, upstreamUseFlag),
    				new CcsStanzaFilter());
    		
    		connection.login(senderId + "@gcm.googleapis.com", apiKey);
    		
    		connList.add(connection);
		}
    	connectionStorage.put(apiKey, connList);
    	storageIdxMap.put(apiKey, 0);
//    	connectionStorage.put(apiKey, connection);
    }
    
    
    public void setSelectAdroidAppInfo(String selectAdroidAppInfo) {
		this.selectAdroidAppInfo = selectAdroidAppInfo;
	}
	
}
