/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Nullable;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Functions {
    public static final Function<Object, String> TO_STRING = ToStringFunction.INSTANCE;
    public static final Function<String, String> TRIM_STRING = TrimStringFunction.INSTANCE;

    private Functions() {
    }

    public static <F> Function<F, String> toStringFunction() {
        return ToStringFunction.INSTANCE;
    }

    public static Function<Object, Integer> toHashCode() {
        return HashCodeFunction.INSTANCE;
    }

    public static Function<String, String> trimString() {
        return TrimStringFunction.INSTANCE;
    }

    public static <E> Function<E, E> identity() {
        return IdentityFunction.INSTANCE;
    }

    public static <A, B> Function<A, B> forMap(Map<? super A, ? extends B> map) {
        return new FunctionForMapNoDefault<A, B>(map);
    }

    public static <A, B> Function<A, B> forMap(Map<? super A, ? extends B> map, @Nullable B defaultValue) {
        if (defaultValue == null) {
            return Functions.forMap(map);
        }
        return new ForMapWithDefault<A, B>(map, defaultValue);
    }

    public static <A, B, C> Function<A, C> compose(Function<? super B, ? extends C> g, Function<? super A, ? extends B> f) {
        return new FunctionComposition<A, B, C>(g, f);
    }

    public static <T> Function<T, Boolean> forPredicate(Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        return new PredicateFunction(predicate);
    }

    public static <E> Function<Object, E> constant(@Nullable E value) {
        return new ConstantFunction<E>(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SerializableFunction<A, B>
    extends Function<A, B>,
    Serializable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstantFunction<E>
    implements SerializableFunction<Object, E> {
        private static final long serialVersionUID = 2347134351918525179L;
        private final E value;

        public ConstantFunction(@Nullable E value) {
            this.value = value;
        }

        @Override
        public E apply(Object from) {
            return this.value;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ConstantFunction) {
                ConstantFunction that = (ConstantFunction)obj;
                return Objects.equal(this.value, that.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            return "constant(" + this.value + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PredicateFunction<T>
    implements SerializableFunction<T, Boolean> {
        private final Predicate<? super T> predicate;
        private static final long serialVersionUID = 7159925838099303368L;

        private PredicateFunction(Predicate<? super T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public Boolean apply(T t) {
            return this.predicate.apply(t);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof PredicateFunction) {
                PredicateFunction that = (PredicateFunction)obj;
                return ((Object)this.predicate).equals(that.predicate);
            }
            return false;
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }

        public String toString() {
            return "asFunction(" + this.predicate + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionComposition<A, B, C>
    implements SerializableFunction<A, C> {
        private final Function<? super B, ? extends C> g;
        private final Function<? super A, ? extends B> f;
        private static final long serialVersionUID = 2530922454216511764L;

        public FunctionComposition(Function<? super B, ? extends C> g, Function<? super A, ? extends B> f) {
            this.g = Preconditions.checkNotNull(g);
            this.f = Preconditions.checkNotNull(f);
        }

        @Override
        public C apply(A a) {
            return this.g.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof FunctionComposition) {
                FunctionComposition that = (FunctionComposition)obj;
                return ((Object)this.f).equals(that.f) && ((Object)this.g).equals(that.g);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.g.hashCode();
        }

        public String toString() {
            return this.g.toString() + "(" + this.f.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForMapWithDefault<A, B>
    implements SerializableFunction<A, B> {
        private static final long serialVersionUID = 1652422010500531299L;
        private final Map<? super A, ? extends B> map;
        private final B defaultValue;

        public ForMapWithDefault(Map<? super A, ? extends B> map, B defaultValue) {
            this.map = Preconditions.checkNotNull(map);
            this.defaultValue = Preconditions.checkNotNull(defaultValue);
        }

        @Override
        public B apply(A a) {
            return this.map.containsKey(a) ? this.map.get(a) : this.defaultValue;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ForMapWithDefault) {
                ForMapWithDefault that = (ForMapWithDefault)o;
                return ((Object)this.map).equals(that.map) && this.defaultValue.equals(that.defaultValue);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.map).hashCode() + this.defaultValue.hashCode();
        }

        public String toString() {
            return "forMap(" + this.map + ", defaultValue=" + this.defaultValue + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionForMapNoDefault<A, B>
    implements SerializableFunction<A, B> {
        private final Map<? super A, ? extends B> map;
        private static final long serialVersionUID = 3270419028101751025L;

        public FunctionForMapNoDefault(Map<? super A, ? extends B> map) {
            this.map = Preconditions.checkNotNull(map);
        }

        @Override
        public B apply(A a) {
            return this.map.get(a);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof FunctionForMapNoDefault) {
                FunctionForMapNoDefault that = (FunctionForMapNoDefault)o;
                return ((Object)this.map).equals(that.map);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.map).hashCode();
        }

        public String toString() {
            return "forMap(" + this.map + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IdentityFunction implements Function<Object, Object>
    {
        INSTANCE;


        @Override
        public Object apply(Object o) {
            return o;
        }

        public String toString() {
            return "identity";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TrimStringFunction implements Function<String, String>
    {
        INSTANCE;


        @Override
        public String apply(String string) {
            return string.trim();
        }

        public String toString() {
            return "String.trim";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HashCodeFunction implements Function<Object, Integer>
    {
        INSTANCE;


        @Override
        public Integer apply(Object o) {
            return o == null ? 0 : o.hashCode();
        }

        public String toString() {
            return "hashCode";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ToStringFunction implements Function<Object, String>
    {
        INSTANCE;


        @Override
        public String apply(Object o) {
            return o.toString();
        }

        public String toString() {
            return "toString";
        }
    }
}

